#include "Block.h"
#include "Level.h"
#include <iostream>


Block::Block()
{
	setCollider(true);

	mushroomTexture.loadFromFile("Assets/Sprites/Game Items/Block/MushroomRelease.png");	//Load the releasing mushroom sprite sheet
	releaseMushroom.addFrame(sf::IntRect(0, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(16, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(32, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(48, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(64, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(80, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(96, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(112, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(128, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(144, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(160, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(176, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(192, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(208, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(224, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(240, 0, 16, 32));
	releaseMushroom.addFrame(sf::IntRect(256, 0, 16, 32));		//	Adding animation frames
	releaseMushroom.setFrameSpeed(1.f / 24.f);	//Speed of release anim

	oneUpTexture.loadFromFile("Assets/Sprites/Game Items/Block/OneUpRelease.png");		//Load the releasing one up sprite sheet
	releaseOneUp.addFrame(sf::IntRect(0, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(16, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(32, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(48, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(64, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(80, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(96, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(112, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(128, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(144, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(160, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(176, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(192, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(208, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(224, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(240, 0, 16, 32));
	releaseOneUp.addFrame(sf::IntRect(256, 0, 16, 32));		//	Adding animation frames
	releaseOneUp.setFrameSpeed(1.f / 24.f);	//Speed of release anim

	questionAnim.addFrame(sf::IntRect(0, 0, 16, 16));
	questionAnim.addFrame(sf::IntRect(16, 0, 16, 16));
	questionAnim.addFrame(sf::IntRect(32, 0, 16, 16));		// Question block "glow" animation, loading frames
	questionAnim.setFrameSpeed(1.f / 5.f);	//Speed of glow

	currentAnimation = nullptr;
}


Block::~Block()
{
}

void Block::create(BlockType type, StoredItems item)
{
	blockType = type;
	spriteType = SpriteType::BlockSprite;

	switch (blockType)
	{
	case Invisible:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Block/Invisible.png");	//Load invisible texture - bit of a cheat, a 16x16 fully transparent image
		break;

	case Destructable:
	case StoredItem:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Block/Destructable.png");	//Load destructable block texture
		break;

	case Floor:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Block/Floor.png");	//Load floor block texture
		break;

	case Stair:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Block/Stair.png");	//Load stair block texture
		break;

	case Question:
		spriteTexture.loadFromFile("Assets/Sprites/Game Items/Block/Question.png");	//Load question block texture
		currentAnimation = &questionAnim;	//Set the block to animate the question block glow
		setTextureRect(currentAnimation->getCurrentFrame());
		break;
	}

	setTexture(&spriteTexture);
	setSize(sf::Vector2f(55, 55));
	setCollisionBox(sf::FloatRect(0, 0, 55, 55));
	storedItem = item;	//Set the item stored within the block to item
}

void Block::update(float dt)
{
	if (currentAnimation != nullptr)
	{
		currentAnimation->animate(dt);
		setTextureRect(currentAnimation->getCurrentFrame());
	}

	if (getItemReleasing())	//If an item is being released
	{
		if (Timer::setWaitTime(0.53, dt))	//Once the animation completes after 0.53s
		{
			currentAnimation = nullptr;	//Stop the animation
			setTextureRect(sf::IntRect(0, 0, 16, 16));	//Set the texture back to the smaller size
			spriteTexture.loadFromFile("Assets/Sprites/Game Items/Block/Hit.png");	//Load the hit texture
			setTexture(&spriteTexture);
			setSize(sf::Vector2f(55, 55));	//Set the size back to the smaller size
			setCollisionBox(sf::FloatRect(0, 0, 55, 55));	//Decrease the collision box size
			setPosition(this->getPosition().x, this->getPosition().y + 55);	//We set the position down 55 pixels to account for the size reduction

			switch (storedItem)
			{
				case StoredItems::StoredPowerUp:
					Level::moveablesManager->spawn(MySprite::MushroomSprite, sf::Vector2f(getPosition().x, getPosition().y - 50));	//Spawn a power up on top of the block
					break;

				case StoredItems::StoredOneUp:
					Level::moveablesManager->spawn(MySprite::OneUpSprite, sf::Vector2f(getPosition().x, getPosition().y - 50));	//Spawn a one up on top of the block
					break;
			}

			storedItem = StoredNothing;	//We've released the item now so we no longer store anything
			isItemReleasing = false;	//The item has been released so we're no longer releasing it
		}
	}
}

void Block::handleCollision(MySprite* sprite, float dt)
{
	if (sprite->getPosition().y + (sprite->getSize().y * 0.65) <= getPosition().y && sprite->getVelocity().y >= 0.f)	//If we touch the top of the block and we're falling
	{
		//Foot collision
		if (sprite->getAirbourne())	//If we're in the air
		{
			sprite->setAirbourne(false);	//We have our feet on the block so we're no longer airbourne
			sprite->setVelocity(0, 0);	//We kill all of our velocity
		}

		else    //Not in the air
		{
			sprite->setVelocity(sprite->getVelocity().x, 0);	//We kill our y velocity but keep the x velocity to allow the player to move horizontally across the block
		}

		sprite->setPosition(sprite->getPosition().x, getPosition().y - sprite->getSize().y);
	}

	else if (sprite->getVelocity().y <= 0.f && (sprite->getPosition().y >= getPosition().y + (getSize().y * 0.65)) && sprite->getPosition().x + sprite->getSize().x > getPosition().x && sprite->getPosition().x < getPosition().x + getSize().x)	//If we're going up and we're underneath both block axis
	{
		//Head collision
		sprite->setAirbourne(true);	//We're about to fall back down, so we're airbourne
		sprite->setVelocity(sf::Vector2f(sprite->getVelocity().x, 0));	//We kill our y velocity in the head collision
		sprite->setPosition(sf::Vector2f(sprite->getPosition().x, getPosition().y + 58));	//We offset ourselves 8 pixels down from the block bottom to prevent accidental multiple collisions
		releaseStoredItem((Mario*)sprite);	//We've made a head collision, and only Mario can collide with his head, so we release the item if there is one
	}

	else 
	{
		//At this point, we MUST have a side collision
		if (sprite->getSpriteType() == SpriteType::MarioSprite)	//If the colliding sprite is Mario
		{
			sprite->setAirbourne(true);	//Mario is still airbourne if he hits the edge
			sprite->setVelocity(sf::Vector2f(0, sprite->getVelocity().y));	//We kill his x velocity
		}

		else
		{
			sprite->setVelocity(-(sprite->getVelocity().x), sprite->getVelocity().y);	//An enemy or moveable must have collided, so we invert their x velocity

			if (sprite->getSpriteType() == SpriteType::KoopaSprite)	//If the enemy is a Koopa
			{
				Level::audioManager->playSoundByName("Collide");	//Play the collide sound to warn the player audibly that the shell has reversed its direction
			}
		}

		if (sprite->getPosition().x + sprite->getSize().x >= getPosition().x + (getSize().x / 2))	//Right side collision
		{
			sprite->setPosition(getPosition().x + getSize().x + 2.f, sprite->getPosition().y);	//We set the sprite's x back to the edge's x coordinate plus a 2 pixel offset to prevent clipping
		}

		else    //Left side collision
		{
			sprite->setPosition(getPosition().x - sprite->getSize().x - 2.f, sprite->getPosition().y);	//We set the sprite's x back to the edge's x coordinate plus a 2 pixel offset to prevent clipping
		}
	}
}

void Block::releaseStoredItem(Mario* mario)
{
	if (!isItemReleasing)	//If we're not already releasing an item
	{
		if (blockType == BlockType::StoredItem || blockType == BlockType::Question || blockType == BlockType::Invisible)	//If we have block types which can store items
		{
			switch (storedItem)
			{
				case StoredItems::StoredCoin:
					isItemReleasing = false;	//Coins release instantly, so we're no longer releasing an item
					currentAnimation = nullptr;	//Stop the animation
					setTextureRect(sf::IntRect(0, 0, 16, 16));	//Set the texture to the correct location on the sprite sheet
					spriteTexture.loadFromFile("Assets/Sprites/Game Items/Block/Hit.png");	//Load the hit texture
					setTexture(&spriteTexture);	
					mario->addCoin();	//Add a coin to Mario
					storedItem = StoredItems::StoredNothing;	//The item has been released so we're no longer storing anything
					break;

				case StoredItems::StoredPowerUp:
					Level::audioManager->playSoundByName("ReleaseItem");
					setTexture(&mushroomTexture);	//Set the mushroom releasing texture
					setSize(sf::Vector2f(55, 110));	//Increase the block size to account for the bigger texture
					setPosition(this->getPosition().x, this->getPosition().y - 55);	//Offset the position to account for the bigger texture
					setCollisionBox(sf::FloatRect(0, 45, 55, 55));	//We offset the collision box to only allow a block collision, not an instant moveable pickup
					currentAnimation = &releaseMushroom;	//Set the block's animation to be releasing the mushroom
					currentAnimation->setLooping(false);	//Do not loop
					isItemReleasing = true;		//We're currently releasing the item
					break;

				case StoredItems::StoredOneUp:
					Level::audioManager->playSoundByName("ReleaseItem");
					setTexture(&oneUpTexture);	//Set the mushroom releasing texture
					setSize(sf::Vector2f(55, 110));	//Increase the block size to account for the bigger texture
					setPosition(this->getPosition().x, this->getPosition().y - 55);	//Offset the position to account for the bigger texture
					setCollisionBox(sf::FloatRect(0, 45, 55, 55));	//We offset the collision box to only allow a block collision, not an instant moveable pickup
					currentAnimation = &releaseOneUp;	//Set the block's animation to be releasing the one up
					currentAnimation->setLooping(false);	//Do not loop
					isItemReleasing = true;	//We're currently releasing the item
					break;
			}
		}

		else if (blockType == BlockType::Destructable)	//Else if we have collided with a destructable block
		{
			if (mario->isPoweredUp())	//If we're powered up
			{
				Level::audioManager->playSoundByName("BlockBreak");
				setAlive(false);	//Set alive to false to destroy the block
			}

			else
			{
				Level::audioManager->playSoundByName("Collide");
			}
		}
	}
}

bool Block::getItemReleasing()
{
	return isItemReleasing;	//Return whether or not we're currently releasing an item
}